/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.whatif;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import cz.insophy.inplan.whatif.WhatIfBound;
import cz.insophy.inplan.whatif.WhatIfEntity;

public class WhatIfResource {
    private final WhatIfEntity entity;
    private final WhatIfBound bound;
    private final long initialValue;
    private long value;

    public WhatIfResource(WhatIfEntity entity, WhatIfBound bound, long initialValue) {
        this.entity = Preconditions.checkNotNull(entity);
        this.bound = Preconditions.checkNotNull(bound);
        if (bound.getMode() == WhatIfBound.BoundMode.ABSOLUTE && (bound.getBound() - (double)initialValue) * (double)bound.getSign() < 0.0) {
            initialValue = (long)bound.getBound();
        }
        this.initialValue = initialValue;
        this.value = initialValue;
    }

    public WhatIfBound getBound() {
        return this.bound;
    }

    public long getBoundValue() {
        return this.bound.getAbsoluteBound(this.initialValue);
    }

    public long getInitialValue() {
        return this.initialValue;
    }

    public long getValue() {
        return this.value;
    }

    void setValue(long value) {
        this.value = this.bound.getStepCorrectValue(this.initialValue, value);
    }

    public double getValueRelative() {
        double range = Math.abs((double)this.initialValue - (double)this.bound.getAbsoluteBound(this.initialValue));
        return range == 0.0 ? 1.0 : (double)Math.abs(this.initialValue - this.value) / range;
    }

    void setValueRelative(double ratio) {
        this.value = this.bound.getAbsoluteValue(this.initialValue, ratio);
    }

    public WhatIfEntity getEntity() {
        return this.entity;
    }

    public boolean isAltered() {
        return this.initialValue != this.value;
    }

    public boolean hasReachedBound() {
        return this.getValueRelative() >= 1.0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("entity", this.entity).add("value", this.value).toString();
    }
}

